#include "SPL/Runtime/Function/SPLFunctions.h"
#include "./subtract_seq_num.h"
#include "../../function/pq/tcpseqnum_max.h"
namespace pq { 
SPL::uint32 subtract_seq_num (const SPL::uint32& seqNum, const SPL::uint32& uSubtract)
{
    const SPL::uint32 id$maxSeqNum = ::pq::tcpseqnum_max();
    const SPL::uint32 id$seqNumSubtract = uSubtract;
    SPL::uint32 id$seqNumResult = seqNum;
    if ((id$seqNumSubtract < seqNum)) 
        {
            id$seqNumResult = SPL::uint32(seqNum - id$seqNumSubtract);
        }
    else
        if ((id$seqNumSubtract > seqNum)) 
            {
                id$seqNumResult = SPL::uint32(SPL::uint32(SPL::uint32(1U) + id$maxSeqNum) - SPL::uint32(id$seqNumSubtract - seqNum));
            }
    return id$seqNumResult;
}
} 
