// eJxtkF9LwzAUxbnfZAwfFKRLV_1EhiBA3p_1aflTrwbaRtNrN2bbhJ0X5728zBKCN5Ofcefvfeo1Xl8IIrI5DS9TJJZV2CC6R_1c5g6zuz4TafE7En4Pxh9fXSB3r0wxnP26jrf0wu2DuM34n1qjCLiBd16477H5V0b7hO_1y3_1DOL1XAXtm233pL5oBMUyrpLkikCYhpagNynoHtuaOah7wokChNYw67j_0CmV5nrRErFAJUg_0bkbGVtvHmvKLVaq2qTc20ezrq3k3Po5JHSwXFtN7kZsbcNHvhAX3LDV0dBIJM1LFptmkMo_01x5ZQOVwyKnAy9FCRLQBg_09X5WQVU0G5A85IXxB



#include "./pkSink.h"
using namespace SPL::_Operator::udpGateway::blueDataSource;

#include <SPL/Runtime/Function/SPLFunctions.h>
#include <SPL/Runtime/Operator/Port/Punctuation.h>


#define MY_OPERATOR_SCOPE SPL::_Operator::udpGateway::blueDataSource
#define MY_BASE_OPERATOR pkSink_Base
#define MY_OPERATOR pkSink$OP


#include <SPL/Runtime/Common/ApplicationRuntimeMessage.h>

using namespace std;
using namespace streams_boost::iostreams;

void MY_OPERATOR_SCOPE::MY_OPERATOR::prepareToShutdown()
{
    _conn.terminate();
}

MY_OPERATOR_SCOPE::MY_OPERATOR::MY_OPERATOR()
: MY_BASE_OPERATOR(), _conn(getPE()), _connected(false)
    
{
}

void MY_OPERATOR_SCOPE::MY_OPERATOR::allPortsReady()
{
    createThreads (1);
}

void MY_OPERATOR_SCOPE::MY_OPERATOR::process(uint32_t)
{
    SPLLOG(L_DEBUG, "UDPSink startup...", SPL_OPER_DBG);
    
        _conn.setup (lit$0, ::SPL::spl_cast<SPL::uint32, SPL::rstring >::cast(lit$1));
    
    SPLLOG(L_DEBUG, "UDPSink connected, file descriptor = " << _conn.fileDescriptor(), SPL_OPER_DBG);
    
    _connected = true;
}


void MY_OPERATOR_SCOPE::MY_OPERATOR::doWrite (const SPL::BufferStream& bs)
{
    if (getPE().getShutdownRequested())
        return;

    // Okay, it worked....
    int ret = ::send (_conn.fileDescriptor(), bs.getDataStart(), bs.getSizeWritten(), 0);
    if (ret < 0) {
        if (errno == ECONNREFUSED)
            return;  // no one listening to what we are sending
        SPLLOG(L_DEBUG, "UDPSink: send failed: " << RuntimeUtility::getErrorNoStr(),
               SPL_OPER_DBG);
   }
}



void MY_OPERATOR_SCOPE::MY_OPERATOR::process(Tuple const & tuple$, uint32_t port)
{
    AutoMutex am(_mutex);
    if (!_connected) {
        SPLLOG(L_DEBUG, "UDPSink: discarded tuple" << tuple$, SPL_OPER_DBG);
        return;
    }

    // IP limited to 64K bytes (minus header)
    char msgBuffer[64*1024];
    streams_boost::iostreams::stream<SPL::BufferStream> sink (msgBuffer, sizeof msgBuffer);
    {
        filtering_streambuf<output> filt_str;
        
        filt_str.push (sink);
        iostream fs(&filt_str);
        fs.imbue(locale::classic());
        
            SPL::StreamByteBuffer sbfs (fs);
        


        // Write to output
        const SPL::BeJwrMXQyKsgGAAacAH1& tuple = static_cast<const SPL::BeJwrMXQyKsgGAAacAH1&>(tuple$);
        
        
            sbfs << tuple;
        
    }
    doWrite (*sink);
}

static SPL::Operator * initer() { return new MY_OPERATOR_SCOPE::MY_OPERATOR(); }
bool MY_BASE_OPERATOR::globalInit_ = MY_BASE_OPERATOR::globalIniter();
bool MY_BASE_OPERATOR::globalIniter() {
    instantiators_.insert(std::make_pair("udpGateway::blueDataSource::pkSink",&initer));
    return true;
}

template<class T> static void initRTC (SPL::Operator& o, T& v, const char * n) {
    SPL::ValueHandle vh = v;
    o.getContext().getRuntimeConstantValue(vh, n);
}

MY_BASE_OPERATOR::MY_BASE_OPERATOR()
 : Operator()  {
    PE & pe = PE::instance();
    uint32_t index = getIndex();
    initRTC(*this, lit$0, "lit$0");
    initRTC(*this, lit$1, "lit$1");
    addParameterValue ("address", SPL::ConstValueHandle(lit$0));
    param$port$0 = ::SPL::spl_cast<SPL::uint32, SPL::rstring >::cast(lit$1);
    addParameterValue ("port", SPL::ConstValueHandle(param$port$0));
    param$format$0 = "bin";
    addParameterValue ("format", SPL::ConstValueHandle(param$format$0));
    (void) getParameters(); // ensure thread safety by initializing here
}
MY_BASE_OPERATOR::~MY_BASE_OPERATOR()
{
    for (ParameterMapType::const_iterator it = paramValues_.begin(); it != paramValues_.end(); it++) {
        const ParameterValueListType& pvl = it->second;
        for (ParameterValueListType::const_iterator it2 = pvl.begin(); it2 != pvl.end(); it2++) {
            delete *it2;
        }
    }
}

void MY_BASE_OPERATOR::processRaw(Tuple const & tuple, uint32_t port) {
    
    static_cast<const  MY_OPERATOR_SCOPE::MY_OPERATOR*>(this)->MY_OPERATOR::process(tuple, port);
}


void MY_BASE_OPERATOR::processRaw(Punctuation const & punct, uint32_t port) {
    
    process(punct, port);
}




