// eJyNUEtLAzEQZv5JKR4UZLvbegoixGJ97RaLe_1Am2TTWsI_1EZKKsv97J_0qqlB0kg_0SbfIzP2hbEydKWwkEFKawrjJJl8buytmpyrmzdXPKz6W7_055FxIfpUlz_0M9tN4tr80sr2tfzE_1s_06rgi7S44MvIjsaNxoMU7u9yxpxHp7sNDLVspzaDtXrVUpXkS7_1C0KGwMYRc6Abz4NG0uUblRAO6o_1NJyEj945N9BXIkXAVUC6cUoG6VCVho6YxX0nRr_1y0MZDWbEmJswN42j1J4PN16PR5tZ4zOGIuMw6GNo52oOFBtjfvpet8ooQU3DB6Ib2uoGlMNSvMv5a8mJdEH6m2JCK
/*  Copyright (c) 2015 TrueStream LLC.  All Rights Reserved.
 */

/** Tun/Tap Source/Sink Operator
 *  Date: 2011-10-24
 *        2016-01-26 copied from NAM repository
 *  Author: db/@terraechos.comterraechos.com
 *	    Brad Bahls (chembrad@msn.com)
 */

/* Additional includes go here */
#include <string>
#include <chrono>


#include "./pkSource.h"
using namespace SPL::_Operator::tapGateway::blueDataSource;

#include <SPL/Runtime/Function/SPLFunctions.h>
#include <SPL/Runtime/Operator/Port/Punctuation.h>

#include <string>

#define MY_OPERATOR_SCOPE SPL::_Operator::tapGateway::blueDataSource
#define MY_BASE_OPERATOR pkSource_Base
#define MY_OPERATOR pkSource$OP





MY_OPERATOR_SCOPE::MY_OPERATOR::MY_OPERATOR()
    : _pBaseOp(NULL)
     ,_cbwBuffer(2048)
     ,_cDroppedBlobs(0)
     ,_cBlobQueueMax(65535)
     ,_cBlobWriteMax(0)
     ,_bReadFailed(false)
     ,_bWriteFailed(false)
{
    const char *pszCloneDeviceName = NULL;
    bool bEnableTunHeader = false;
    
    if (NULL != pszCloneDeviceName)
    {
        _tunKeeper.set_clone_device(pszCloneDeviceName);
    }
    _tunKeeper.enable_tun_protocol_header(bEnableTunHeader);
}

MY_OPERATOR_SCOPE::MY_OPERATOR::~MY_OPERATOR() 
{
    if (NULL != _pBaseOp)
    {
        _tunKeeper.close_tun(_pBaseOp->get_tun());
        delete _pBaseOp;
        _pBaseOp = NULL;
    }
}

bool MY_OPERATOR_SCOPE::MY_OPERATOR::is_tap()
const
{
    tuntaptype kType = tap;
    
    return (tap == kType);
}

/// centralized accessor method to try and open the Tun/Tap specified by
/// the operator params
tun::tun_op* 
MY_OPERATOR_SCOPE::MY_OPERATOR::try_tun()
{
    if (NULL == _pBaseOp)
    {
        tun::tun_t hTun;
        unsigned int cTimeoutMicroseconds = ::SPL::spl_cast<SPL::uint32, SPL::rstring >::cast(lit$1);
        bool bTap = is_tap();
        std::string interfaceName(lit$0);
        const char *pszInterfaceName = interfaceName.c_str();
        bool bReadable = true;
        bool bWritable = true;
        tun::tunerr_t kError = 0;
        
        hTun = _tunKeeper.open_tun(
             bTap
            ,pszInterfaceName
            ,bReadable
            ,bWritable
            ,&kError
            );
        if (0 == kError)
        {
            _pBaseOp = new tun::tun_op(hTun, cTimeoutMicroseconds);
        }
    }
    
    return _pBaseOp;
}

/// Read one frame from the tun (or time-out waiting for one)
unsigned int 
MY_OPERATOR_SCOPE::MY_OPERATOR::tun_read_one(
     tun::tun_op &tunOp
    ,unsigned char *pb
    ,unsigned int cbw
    )
{
    tun::tunerr_t kError = 0;
    unsigned int cbr;
    
    cbr = tunOp.read_bytes((char*)pb, cbw, &kError);
    if (0 == kError)
    {
        if (_bReadFailed)
        {
            SPLLOG(L_ERROR, "Suceeded reading packet", "TUN");
            _bReadFailed = false;
        }
    }
    else
    {
        if ( !_bReadFailed)
        {
            SPLLOG(L_ERROR, "Failed to read packet", "TUN");
            _bReadFailed = true;
        }
    }
    
    return cbr;
}

/// submit a new tuple for a frame of data from the Tun
void 
MY_OPERATOR_SCOPE::MY_OPERATOR::submit_one(
     const unsigned char *pb
    ,unsigned int cbr
    )
{

    const uint32 iOutputPort = 0;
    
    if (NULL != pb && 0 < cbr)
    {
        OPort0Type outputTuple;
        SPL::blob &dataBlob = outputTuple.get_pk();
        uint64_t lcbr = cbr;
        
        // copy data from input buffer into blob inside tuple
        dataBlob.setData(pb, lcbr);
        
        submit(outputTuple, iOutputPort);
    }
    

}

/// Write blobs from the blob queue out to the Tun/Tap
void 
MY_OPERATOR_SCOPE::MY_OPERATOR::tun_write_blobs(tun::tun_op &tunOp)
{


    const uint64_t cBlobWriteMax = _cBlobWriteMax;
    uint64_t cBlobsWritten;
    const unsigned char *pb;
    unsigned int cbr;
    uint64_t lcbr;
    tun::tunerr_t kError;
    
    SPL::AutoMutex blobQueueLock(_blobQueueMutex);
    
    cBlobsWritten = 0;
    kError = 0;
    while ( !_blobQueue.empty()
        && (0 == cBlobWriteMax
            || cBlobsWritten < cBlobWriteMax
            )
        && 0 == kError
        )
    {
        SPL::blob const &dataBlob = _blobQueue.front();
        
        SPLLOG(L_ERROR, "Reading packet from write queue...", "TUN");
        
        lcbr = 0;
        pb = dataBlob.getData(lcbr);
        if (lcbr > 0xffffffffull)
        {
            // TODO: log this, but not a million times
            // Remove it from the queue so it doesn't hold anything else up
            _blobQueue.pop();
        }
        else if (lcbr > 0)
        {
            cbr = (unsigned int)lcbr;
            kError = 0;
            tunOp.write_bytes((const char*)pb, cbr, &kError);
            if (0 == kError)
            {
                SPLLOG(L_ERROR, "Wrote packet to tun", "TUN");
                if (_bWriteFailed)
                {
                    // we print this only if we failed last time around
                    SPLLOG(L_ERROR, "Succeeded writing packet", "TUN");
                }
                _bWriteFailed = false;
                cBlobsWritten++;
                _blobQueue.pop();
            }
            else
            {
                if ( !_bWriteFailed)
                {
                    // only print this the first time we fail to write
                    SPLLOG(L_ERROR, "Failed to write packet", "TUN");
                    _bWriteFailed = true;
                }
            }
        }
    }


}


/// Notifies that all ports are ready. No tuples should be submitted before
/// this. Source operators can use this method to spawn threads.
void MY_OPERATOR_SCOPE::MY_OPERATOR::allPortsReady() 
{

    // Create thread that will read from Tun.
    // It is likely that using several threads would cause problems.
    createThreads(1);
}
 
// Notify pending shutdown
// This is an asynchronous call
void MY_OPERATOR_SCOPE::MY_OPERATOR::prepareToShutdown() 
{
}

// Processing for source and threaded operators   
void MY_OPERATOR_SCOPE::MY_OPERATOR::process(uint32_t idx)
{

    const double retryTunSeconds = 1.0;
    unsigned int cTunFailures = 0;
    SPL::ProcessingElement &pe = getPE();
    tun::tun_op *pTun;
    const unsigned int cbwBuffer = _cbwBuffer;
    unsigned int cbrBuffer;
    unsigned char *pbBuffer;

    unsigned int packets = 0;
    
    pbBuffer = NULL;
    if (0 < cbwBuffer)
    {
        pbBuffer = new unsigned char[cbwBuffer];
    }
    
    pTun = NULL;
    while (NULL != pbBuffer
        && 0 < cbwBuffer
        && !pe.getShutdownRequested()
        )
    {
        if (NULL == pTun)
        {
            pTun = try_tun();
        }
        
        if (NULL == pTun)
        {
            if (0 == cTunFailures)
            {
                // first failure, don't write this to log endlessly
                SPLLOG(L_ERROR, "Could not open Tun/Tap, will retry...", "TUN");
            }
            cTunFailures++;
            // maybe the Tun is not ready, try again later
            pe.blockUntilShutdownRequest(retryTunSeconds);
        }
        else
        {
            if (0 < cTunFailures)
            {
                SPLLOG(L_ERROR, "Tun/Tap was opened successfully", "TUN");
                // reset counter so we don't keep printing the log message
                cTunFailures = 0;
            }
            
            cbrBuffer = tun_read_one(*pTun, pbBuffer, cbwBuffer);
            if (0 < cbrBuffer)
            {
                //auto begin = std::chrono::monotonic_clock::now();
                submit_one(pbBuffer, cbrBuffer);
                //auto end = std::chrono::monotonic_clock::now();
                //int dur = std::chrono::duration_cast<std::chrono::microseconds>(end - begin).count();
                //std::string durstr = std::to_string((long long int)dur);
                //SPLLOG(L_ERROR, dur, "TUN");
            }
            tun_write_blobs(*pTun);
        }
    }
    
    if (NULL != pbBuffer)
    {
        delete[] pbBuffer;
        pbBuffer = NULL;
    }
    

}

void MY_OPERATOR_SCOPE::MY_OPERATOR::process(Tuple & tuple, uint32_t port)
{
    Tuple const & constTuple = tuple;
    process(constTuple, port);
}

void MY_OPERATOR_SCOPE::MY_OPERATOR::process(Tuple const & tuple, uint32_t port)
{
    const uint32_t iSinkInputPort = 0;
    

    if (iSinkInputPort == port)
    {
        IPort0Type const &inputTuple = (IPort0Type const &)tuple;
        SPL::blob const &dataBlob = inputTuple.get_pk();

        SPL::AutoMutex blobQueueLock(_blobQueueMutex);
        
        // Copy blob into Queue, we will actually write it to the TUN
        //  when it stops blocking for incoming (source) traffic
        // This will invoke a copy-constructor in the Queue which will
        //  copy the data in the blob object into the queue
        if (0 == _cBlobQueueMax
            || _blobQueue.size() < _cBlobQueueMax
            )
        {
            _blobQueue.push(dataBlob);
        }
        else
        {
            // keep a count of dropped blobs so we can log this
            _cDroppedBlobs++;
        }
    }

}

void MY_OPERATOR_SCOPE::MY_OPERATOR::process(Punctuation const & punct, uint32_t port)
{
}

static SPL::Operator * initer() { return new MY_OPERATOR_SCOPE::MY_OPERATOR(); }
bool MY_BASE_OPERATOR::globalInit_ = MY_BASE_OPERATOR::globalIniter();
bool MY_BASE_OPERATOR::globalIniter() {
    instantiators_.insert(std::make_pair("tapGateway::blueDataSource::pkSource",&initer));
    return true;
}

template<class T> static void initRTC (SPL::Operator& o, T& v, const char * n) {
    SPL::ValueHandle vh = v;
    o.getContext().getRuntimeConstantValue(vh, n);
}

MY_BASE_OPERATOR::MY_BASE_OPERATOR()
 : Operator()  {
    PE & pe = PE::instance();
    uint32_t index = getIndex();
    initRTC(*this, lit$0, "lit$0");
    initRTC(*this, lit$1, "lit$1");
    param$deviceType$0 = "tap";
    addParameterValue ("deviceType", SPL::ConstValueHandle(param$deviceType$0));
    addParameterValue ("interface", SPL::ConstValueHandle(lit$0));
    param$timeoutMicroseconds$0 = ::SPL::spl_cast<SPL::uint32, SPL::rstring >::cast(lit$1);
    addParameterValue ("timeoutMicroseconds", SPL::ConstValueHandle(param$timeoutMicroseconds$0));
    (void) getParameters(); // ensure thread safety by initializing here
    $oportBitset = OPortBitsetType(std::string("01"));
}
MY_BASE_OPERATOR::~MY_BASE_OPERATOR()
{
    for (ParameterMapType::const_iterator it = paramValues_.begin(); it != paramValues_.end(); it++) {
        const ParameterValueListType& pvl = it->second;
        for (ParameterValueListType::const_iterator it2 = pvl.begin(); it2 != pvl.end(); it2++) {
            delete *it2;
        }
    }
}

void MY_BASE_OPERATOR::processRaw(Tuple & tuple, uint32_t port) {
    
    static_cast< MY_OPERATOR_SCOPE::MY_OPERATOR*>(this)->MY_OPERATOR::process(tuple, port);
}


void MY_BASE_OPERATOR::processRaw(Punctuation const & punct, uint32_t port) {
    
    if (punct == Punctuation::FinalMarker) {
        process(punct, port);
        bool forward = false;
        {
            AutoPortMutex $apm($fpMutex, *this);
            $oportBitset.reset(port);
            if ($oportBitset.none()) {
                $oportBitset.set(1);
                forward=true;
            }
        }
        if(forward)
            submit(punct, 0);
        return;
    }
    
    process(punct, port);
}





