#include "SPL/Runtime/Function/SPLFunctions.h"
#include "./macaddr_is_invalid.h"
#include "../../function/pq/macaddr_zero.h"
namespace pq { 
SPL::boolean macaddr_is_invalid (const SPL::blist<SPL::uint8, 6>& mac)
{
    SPL::boolean id$isInvalid = false;
    if ((::SPL::Functions::Collections::size(mac) != SPL::int32(6))) 
        {
            id$isInvalid = true;
        }
    else
        if ((mac == ::pq::macaddr_zero())) 
            {
                id$isInvalid = true;
            }
    return id$isInvalid;
}
} 
