#include "SPL/Runtime/Function/SPLFunctions.h"
#include "./format_icmp6_msg_string.h"
namespace pq { 
SPL::rstring format_icmp6_msg_string (const SPL::uint8& icmpType, const SPL::uint8& icmpCode)
{
    SPL::rstring id$msgString = SPL::rstring("");
    if ((SPL::uint8(129) == icmpType)) 
        {
            id$msgString = ((SPL::rstring("ECHO[") + ::SPL::spl_cast<SPL::rstring, SPL::uint8 >::cast(icmpCode)) + SPL::rstring("]"));
        }
    else
        if ((SPL::uint8(128) == icmpType)) 
            {
                id$msgString = ((SPL::rstring("PING[") + ::SPL::spl_cast<SPL::rstring, SPL::uint8 >::cast(icmpCode)) + SPL::rstring("]"));
            }
        else
            if ((SPL::uint8(1) == icmpType)) 
                {
                    id$msgString = ((SPL::rstring("UNREACHED[") + ::SPL::spl_cast<SPL::rstring, SPL::uint8 >::cast(icmpCode)) + SPL::rstring("]"));
                }
            else
                {
                    id$msgString = (((::SPL::spl_cast<SPL::rstring, SPL::uint8 >::cast(icmpType) + SPL::rstring("[")) + ::SPL::spl_cast<SPL::rstring, SPL::uint8 >::cast(icmpCode)) + SPL::rstring("]"));
                }
    return id$msgString;
}
} 
